/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.ws;

import filenet.vw.base.VWDebug;
import filenet.vw.base.VWUDDIRegistry;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.ws.base.VWUDDIRegistryItem;
import filenet.ws.api.uddi.WSBusinessEntity;
import filenet.ws.api.uddi.WSUDDIRegistry;
import filenet.ws.api.uddi.WSUDDIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.error.RegistryException;

public class VWUDDIBusinessImportDialog
extends VWModalDialog
implements ActionListener,
KeyListener {
    public static final int STATUS_OK = 0;
    public static final int STATUS_CANCLE = 1;
    public static final int STATUS_HELP = 2;
    private JTextField m_keyTextField = null;
    private JTextField m_userTextField = null;
    private JTextArea m_warningMsg = null;
    private JButton m_okButton = new JButton(VWResource.OK);
    private JButton m_cancelButton = new JButton(VWResource.Cancel);
    private JButton m_helpButton = new JButton(VWResource.Help);
    private Frame m_parentFrame = null;
    private int m_returnStatus = 1;
    private String m_businessKey = null;
    private String m_publishUser = null;
    private VWUDDIRegistry m_vwUDDIRegistry = null;
    private WSUDDIRegistry m_wsUDDIRegistry = null;
    private WSBusinessEntity m_wsBusinessEntity = null;
    private Dimension m_dialogDimension = null;

    public VWUDDIBusinessImportDialog(Frame parent, VWUDDIRegistryItem vwUDDIRegistryItem) {
        super(parent);
        this.m_parentFrame = parent;
        this.m_vwUDDIRegistry = vwUDDIRegistryItem.getVWUDDIRegistry();
        this.init();
    }

    public VWUDDIBusinessImportDialog(Frame parent, VWUDDIRegistry vwUDDIRegistry) {
        super(parent);
        this.m_parentFrame = parent;
        this.m_vwUDDIRegistry = vwUDDIRegistry;
        this.init();
    }

    public int getReturnStatus() {
        return this.m_returnStatus;
    }

    public String getBusinessKey() {
        return this.m_businessKey;
    }

    public String getPublishUser() {
        return this.m_publishUser;
    }

    public WSBusinessEntity getWSBusinessEntity() {
        return this.m_wsBusinessEntity;
    }

    public void releaseResources() {
        if (this.m_keyTextField != null) {
            this.m_keyTextField.removeAll();
            this.m_keyTextField = null;
        }
        if (this.m_userTextField != null) {
            this.m_userTextField.removeAll();
            this.m_userTextField = null;
        }
        if (this.m_okButton != null) {
            this.m_okButton.removeActionListener(this);
            this.m_okButton.removeAll();
            this.m_okButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton.removeAll();
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton.removeAll();
            this.m_helpButton = null;
        }
        this.removeAll();
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj == this.m_cancelButton) {
            this.m_returnStatus = 1;
            this.setVisible(false);
        } else if (obj == this.m_okButton) {
            if (this.validateBusinessKey()) {
                String txt = this.m_userTextField.getText();
                if (txt != null) {
                    this.m_publishUser = txt.trim();
                }
                this.m_returnStatus = 0;
                this.setVisible(false);
            }
        } else if (obj == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc092.htm");
        } else if (obj == this.m_keyTextField) {
            JButton defaultButton = this.getRootPane().getDefaultButton();
            defaultButton.doClick();
        }
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
        Object source = event.getSource();
        if (source == this.m_keyTextField) {
            this.m_okButton.setEnabled(true);
        }
    }

    protected JPanel createMainPanel() {
        JPanel mainPanel = null;
        try {
            mainPanel = new JPanel();
            mainPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            mainPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.anchor = 21;
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            gbConst.fill = 0;
            gbConst.weightx = 0.0;
            gbConst.weighty = 0.0;
            gbConst.insets = new Insets(4, 4, 4, 4);
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.fill = 0;
            gbConst.weightx = 0.0;
            gbConst.weighty = 0.0;
            JLabel keyLabel = new JLabel(VWResource.s_label.toString(VWResource.s_businessKey));
            mainPanel.add((Component)keyLabel, gbConst);
            VWAccessibilityHelper.setAccessibility(keyLabel, this, VWResource.s_businessKey, VWResource.s_businessKey);
            ++gbConst.gridx;
            gbConst.fill = 2;
            gbConst.weightx = 1.0;
            this.m_keyTextField = new JTextField();
            this.m_keyTextField.addKeyListener(this);
            mainPanel.add((Component)this.m_keyTextField, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_keyTextField, this, VWResource.s_businessKey, VWResource.s_businessKey);
            VWAccessibilityHelper.setLabelFor(keyLabel, this.m_keyTextField);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.fill = 0;
            gbConst.weightx = 0.0;
            JLabel publishUserNameLabel = new JLabel(VWResource.s_label.toString(VWResource.s_publishUserName));
            mainPanel.add((Component)publishUserNameLabel, gbConst);
            VWAccessibilityHelper.setAccessibility(publishUserNameLabel, this, VWResource.s_publishUserName, VWResource.s_publishUserName);
            ++gbConst.gridx;
            gbConst.fill = 2;
            gbConst.weightx = 1.0;
            this.m_userTextField = new JTextField();
            this.m_userTextField.addKeyListener(this);
            mainPanel.add((Component)this.m_userTextField, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_userTextField, this, VWResource.s_publishUserName, VWResource.s_publishUserName);
            VWAccessibilityHelper.setLabelFor(publishUserNameLabel, this.m_userTextField);
            String businessName = this.m_vwUDDIRegistry.getBusinessName();
            if (businessName != null && businessName.length() > 0) {
                gbConst.gridx = 0;
                ++gbConst.gridy;
                gbConst.fill = 0;
                gbConst.weightx = 0.0;
                JLabel warningLabel = new JLabel(VWResource.s_label.toString(VWResource.s_warning));
                mainPanel.add((Component)warningLabel, gbConst);
                VWAccessibilityHelper.setAccessibility(warningLabel, this, VWResource.s_warning, VWResource.s_warning);
                ++gbConst.gridx;
                gbConst.fill = 2;
                gbConst.gridwidth = 0;
                this.m_warningMsg = new JTextArea(VWResource.s_businessImportMsg);
                this.m_warningMsg.setBackground(this.getBackground());
                this.m_warningMsg.setWrapStyleWord(true);
                this.m_warningMsg.setLineWrap(true);
                Font aFont = this.getFont();
                this.m_warningMsg.setBorder(new EmptyBorder(10, 0, 10, 10));
                this.m_warningMsg.setFont(new Font(aFont.getName(), 1, aFont.getSize()));
                mainPanel.add((Component)this.m_warningMsg, gbConst);
                this.setSize(this.m_dialogDimension.width, this.m_dialogDimension.height + 20);
                VWAccessibilityHelper.setAccessibility(this.m_warningMsg, this, VWResource.s_warning, VWResource.s_warning);
                VWAccessibilityHelper.setLabelFor(warningLabel, this.m_warningMsg);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    protected JPanel createButtonPanel() {
        JPanel mainPanel = null;
        GridBagConstraints gbConst = new GridBagConstraints();
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            gbConst.fill = 2;
            gbConst.gridwidth = 2;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(10, 10, 10, 10);
            mainPanel.add((Component)this.m_okButton, gbConst);
            mainPanel.add((Component)this.m_cancelButton, gbConst);
            mainPanel.add((Component)this.m_helpButton, gbConst);
            this.m_okButton.addActionListener(this);
            this.m_cancelButton.addActionListener(this);
            this.m_helpButton.addActionListener(this);
            this.setOKButtonState();
            VWAccessibilityHelper.setAccessibility(this.m_okButton, this, this.m_okButton.getText(), this.m_okButton.getText());
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, this, this.m_cancelButton.getText(), this.m_cancelButton.getText());
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, this.m_helpButton.getText(), this.m_helpButton.getText());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    private void init() {
        try {
            this.setTitle(VWResource.BusinessInformation);
            VWAccessibilityHelper.setAccessibility(this, null, VWResource.BusinessInformation, VWResource.BusinessInformation);
            this.m_dialogDimension = VWStringUtils.stringToDimension("555,165");
            if (this.m_dialogDimension == null) {
                this.m_dialogDimension = new Dimension(500, 150);
            }
            this.setSize(this.m_dialogDimension.width, this.m_dialogDimension.height);
            this.setVisible(false);
            this.m_wsUDDIRegistry = new WSUDDIRegistry(this.m_vwUDDIRegistry.getName(), this.m_vwUDDIRegistry.getInquiryURL(), this.m_vwUDDIRegistry.getPublishURL(), this.m_vwUDDIRegistry.isPublishable());
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.createMainPanel(), "Center");
            this.getContentPane().add((Component)this.createButtonPanel(), "Last");
            this.setLocationRelativeTo(this.m_parentFrame);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private boolean validateBusinessKey() {
        boolean bOK;
        block7: {
            bOK = false;
            this.m_businessKey = this.m_keyTextField.getText();
            if (this.m_businessKey != null && this.m_businessKey.length() > 0) {
                try {
                    this.m_wsBusinessEntity = this.m_wsUDDIRegistry.findBusinessByKey(this.m_businessKey.trim());
                    if (this.m_wsBusinessEntity != null) {
                        BusinessEntity businessEntity = this.m_wsBusinessEntity.getBusinessEntity();
                        businessEntity.setBusinessServices(null);
                        bOK = true;
                        break block7;
                    }
                    VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.InvalidBusinessKey, VWResource.ErrorMessage, 1);
                }
                catch (RegistryException ex) {
                    String errMsg = WSUDDIUtils.getErrMsg(ex);
                    if (!(errMsg != null && errMsg.length() > 0 || (errMsg = ex.getMessage()) != null && errMsg.length() > 0)) {
                        errMsg = ex.toString();
                    }
                    VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.UDDIException.toString(errMsg), VWResource.ErrorMessage, 1);
                    VWDebug.logException((Exception)((Object)ex));
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            } else {
                VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.MissingBusinessKey, VWResource.ErrorMessage, 1);
            }
        }
        return bOK;
    }

    private void setOKButtonState() {
        this.getRootPane().setDefaultButton(this.m_okButton);
        boolean bEnable = true;
        String tempString = null;
        if (this.m_keyTextField != null) {
            tempString = this.m_keyTextField.getText();
            if (tempString == null || VWStringUtils.compare(tempString, "") == 0) {
                bEnable = false;
            }
        } else {
            bEnable = false;
        }
        if (this.m_okButton.isEnabled() != bEnable) {
            this.m_okButton.setEnabled(bEnable);
        }
    }
}

